(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     43431,       1646]*)
(*NotebookOutlinePosition[     71204,       2288]*)
(*  CellTagsIndexPosition[     65078,       2160]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Other Information", "IndexSection",
  CellTags->"MasterIndexHeading"],

Cell[" Menu Commands ", "IndexSection"],

Cell[TextData[{
  StyleBox["New", "MR"],
  " (menu command) ",
  ButtonBox["New",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"New (menu command)"],

Cell[TextData[{
  StyleBox["Open...", "MR"],
  " (menu command) ",
  ButtonBox["Open...",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Open (menu command)"],

Cell[TextData[{
  StyleBox["Close", "MR"],
  " (menu command) ",
  ButtonBox["Close",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Close (menu command)"],

Cell[TextData[{
  StyleBox["Save", "MR"],
  " (menu command) ",
  ButtonBox["Save",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Save (menu command)"],

Cell[TextData[{
  StyleBox["Save As...", "MR"],
  " (menu command) ",
  ButtonBox["Save As...",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Save As (menu command)"],

Cell[TextData[{
  StyleBox["Save As Special...", "MR"],
  " (menu command) ",
  ButtonBox["Save As Special...",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Save As Special (menu command)"],

Cell[TextData[{
  StyleBox["Pre-3.0 Notebook", "MR"],
  " (menu command) ",
  ButtonBox["Pre-3.0 Notebook",
    ButtonData:>"Save As Special: Pre-3.0 Notebook",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Text", "MR"],
  " (menu command) ",
  ButtonBox["Text",
    ButtonData:>"Save As Special: Text",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["CellExpression", "MR"],
  " (menu command) ",
  ButtonBox["CellExpression",
    ButtonData:>"Save As Special: CellExpression",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["NotebookExpression", "MR"],
  " (menu command) ",
  ButtonBox["NotebookExpression",
    ButtonData:>"Save As Special: NotebookExpression",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Package Format", "MR"],
  " (menu command) ",
  ButtonBox["Package Format",
    ButtonData:>"Save As Special: Package Format",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["TeX", "MR"],
  " (menu command) ",
  ButtonBox["TeX",
    ButtonData:>"Save As Special: TeX",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["HTML", "MR"],
  " (menu command)",
  ButtonBox["HTML",
    ButtonData:>"Save As Special: HTML",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Open Special", "MR"],
  " (menu command) ",
  ButtonBox["Open Special",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Open Selection", "MR"],
  " (menu command) ",
  ButtonBox["Open Selection",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Import", "MR"],
  " (menu command) ",
  ButtonBox["Import",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Import (menu command)"],

Cell[TextData[{
  StyleBox["Palettes", "MR"],
  " (menu command) ",
  ButtonBox["Palettes",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Palettes (menu command)"],

Cell[TextData[{
  StyleBox["Notebooks", "MR"],
  " (menu command) ",
  ButtonBox["Notebooks",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Notebooks (menu command)"],

Cell[TextData[{
  StyleBox["Generate Palette from Selection", "MR"],
  " (menu command) ",
  ButtonBox["Generate Palette from Selection",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Generate Palette from Selection (menu command)"],

Cell[TextData[{
  StyleBox["Generate Notebook from Palette", "MR"],
  " (menu command) ",
  ButtonBox["Generate Notebook from Palette",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Generate Notebook from Palette (menu command)"],

Cell[TextData[{
  StyleBox["Printing Setting", "MR"],
  StyleBox["s", "MR"],
  " (menu command)"
}], "Index",
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Page Setup ", "MR"],
  "(menu command) ",
  ButtonBox["Page Setup",
    ButtonData:>"Printing Settings: Page Setup",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Printing Options ", "MR"],
  "(menu command) ",
  ButtonBox["Printing Options",
    ButtonData:>"Printing Settings: Printing Options",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Headers and Footers", "MR"],
  " (menu command) ",
  ButtonBox["Headers and Footers",
    ButtonData:>"Printing Settings: Headers and Footers",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Print...", "MR"],
  " (menu command) ",
  ButtonBox["Print...",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Print... (menu command)"],

Cell[TextData[{
  StyleBox["Print Selection", "MR"],
  " (menu command) ",
  ButtonBox["Print Selection",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Print Selection (menu command)"],

Cell[TextData[{
  StyleBox["Quit", "MR"],
  " (menu command) ",
  ButtonBox["Quit ",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Quit (menu command)"],

Cell[TextData[{
  StyleBox["Undo", "MR"],
  " (menu command) ",
  ButtonBox["Undo",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Undo (menu command)"],

Cell[TextData[{
  StyleBox["Cut", "MR"],
  " (menu command) ",
  ButtonBox["Cut",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Cut (menu command)"],

Cell[TextData[{
  StyleBox["Copy", "MR"],
  " (menu command) ",
  ButtonBox["Copy",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Copy (menu command)"],

Cell[TextData[{
  StyleBox["Paste", "MR"],
  " (menu command) ",
  ButtonBox["Paste",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Paste (menu command)"],

Cell[TextData[{
  StyleBox["Clear", "MR"],
  " (menu command) ",
  ButtonBox["Clear",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Clear (menu command)"],

Cell[TextData[{
  StyleBox["Paste and Discard", "MR"],
  " (menu command) ",
  ButtonBox["Paste and Discard",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Paste and Discard (menu command)"],

Cell[TextData[{
  StyleBox["Copy As", "MR"],
  " (menu command) ",
  ButtonBox["Copy As",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Copy As (menu command)"],

Cell[TextData[{
  StyleBox["Save Selection As...", "MR"],
  " (menu command) ",
  ButtonBox["Save Selection As...",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Save Selection As (menu command)"],

Cell[TextData[{
  StyleBox["Select All", "MR"],
  " (menu command) ",
  ButtonBox["Select All",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Select All (menu command)"],

Cell[TextData[{
  StyleBox["Motion", "MR"],
  " (menu command) ",
  ButtonBox["Motion",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Motion (menu command)"],

Cell[TextData[{
  StyleBox["Expression Input", "MR"],
  " (menu command) ",
  ButtonBox["Expression Input",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Expression Input (menu command)"],

Cell[TextData[{
  StyleBox["Expression Input Commands ", "MR"],
  "(menu command) ",
  ButtonBox["Expression Input Commands",
    ButtonData:>"Expression Input: Expression Input Commands",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Insert Raw Expression ", "MR"],
  "(menu command) ",
  ButtonBox["Insert Raw Expression",
    ButtonData:>"Expression Input: Insert Raw Expression",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Make 2D", "MR"],
  " (menu command) ",
  ButtonBox["Make 2D",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Make 2D (menu command)"],

Cell[TextData[{
  StyleBox["Check Balance", "MR"],
  " (menu command) ",
  ButtonBox["Check Balance",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Check Balance (menu command)"],

Cell[TextData[{
  StyleBox["Shift Left ", "MR"],
  " (menu command) ",
  ButtonBox["Shift Left",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Shift Left (menu command)"],

Cell[TextData[{
  StyleBox["Shift Right", "MR"],
  " (menu command) ",
  ButtonBox["Shift Right",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Shift Right (menu command)"],

Cell[TextData[{
  StyleBox["Preferences...", "MR"],
  " (menu command) ",
  ButtonBox["Preferences...",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Preferences (menu command)"],

Cell[TextData[{
  StyleBox["Cell", "MR"],
  " (menu command) ",
  ButtonBox["Cell",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Cell (menu command)"],

Cell[TextData[{
  StyleBox["Convert To", "MR"],
  " (menu command)"
}], "Index",
  CellTags->"Convert To (menu command)"],

Cell[TextData[{
  StyleBox["InputForm", "MR"],
  " (menu command) ",
  ButtonBox["InputForm",
    ButtonData:>"Convert To: InputForm",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["StandardForm", "MR"],
  " (menu command) ",
  ButtonBox["StandardForm",
    ButtonData:>"Convert To: StandardForm",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["TraditionalForm", "MR"],
  " (menu command) ",
  ButtonBox["TraditionalForm",
    ButtonData:>"Convert To: TraditionalForm",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["PostScript", "MR"],
  " (menu command) ",
  ButtonBox["PostScript",
    ButtonData:>"Convert To: PostScript",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Bitmap", "MR"],
  " (menu command) ",
  ButtonBox["Bitmap",
    ButtonData:>"Convert To: Bitmap",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["PICT", "MR"],
  " (menu command) ",
  ButtonBox["PICT",
    ButtonData:>"Convert To: PICT",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["BitmapPICT", "MR"],
  " (menu command) ",
  ButtonBox["BitmapPICT",
    ButtonData:>"Convert To: BitmapPICT",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Embedded PS PICT", "MR"],
  " (menu command) ",
  ButtonBox["Embedded PS PICT",
    ButtonData:>"Convert To: Embedded PS PICT",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["QuickTime", "MR"],
  " (menu command) ",
  ButtonBox["QuickTime",
    ButtonData:>"Convert To: QuickTime",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Display As", "MR"],
  " (menu command)"
}], "Index",
  CellTags->"Display As (menu command)"],

Cell[TextData[{
  StyleBox["Text", "MR"],
  " (menu command) ",
  ButtonBox["Text",
    ButtonData:>"Display As: Text",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Input", "MR"],
  " (menu command) ",
  ButtonBox["Input",
    ButtonData:>"Display As: Input",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["StandardForm", "MR"],
  " (menu command) ",
  ButtonBox["StandardForm",
    ButtonData:>"Display As: StandardForm",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["TraditionalForm", "MR"],
  " (menu command) ",
  ButtonBox["TraditionalForm",
    ButtonData:>"Display As: TraditionalForm",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Default Input FormatType", "MR"],
  " (menu command)"
}], "Index",
  CellTags->"Default Input FormatType (menu command)"],

Cell[TextData[{
  StyleBox["InputForm", "MR"],
  " (menu command) ",
  ButtonBox["InputForm",
    ButtonData:>"Default Input FormatType: InputForm",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["StandardForm", "MR"],
  " (menu command) ",
  ButtonBox["StandardForm",
    ButtonData:>"Default Input FormatType: StandardForm",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["TraditionalForm", "MR"],
  " (menu command) ",
  ButtonBox["TraditionalForm",
    ButtonData:>"Default Input FormatType: TraditionalForm",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Default Output FormatType", "MR"],
  " (menu command)"
}], "Index",
  CellTags->"Default Output FormatType (menu command)"],

Cell[TextData[{
  StyleBox["OutputForm", "MR"],
  " (menu command) ",
  ButtonBox["OutputForm",
    ButtonData:>"Default Output FormatType: OutputForm",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["InputForm", "MR"],
  " (menu command) ",
  ButtonBox["InputForm",
    ButtonData:>"Default Output FormatType: InputForm",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["StandardForm", "MR"],
  " (menu command) ",
  ButtonBox["StandardForm",
    ButtonData:>"Default Output FormatType: StandardForm",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["TraditionalForm", "MR"],
  " (menu command) ",
  ButtonBox["TraditionalForm",
    ButtonData:>"Default Output FormatType: TraditionalForm",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Default Inline FormatType", "MR"],
  " (menu command)"
}], "Index",
  CellTags->"Default Inline FormatType (menu command)"],

Cell[TextData[{
  StyleBox["StandardForm", "MR"],
  " (menu command) ",
  ButtonBox["StandardForm",
    ButtonData:>"Default Inline FormatType: StandardForm",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["TraditionalForm", "MR"],
  " (menu command) ",
  ButtonBox["TraditionalForm",
    ButtonData:>"Default Inline FormatType: TraditionalForm",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Cell Properties", "MR"],
  " (menu command)"
}], "Index",
  CellTags->"Cell Properties (menu command)"],

Cell[TextData[{
  StyleBox["Cell Open", "MR"],
  " (menu command) ",
  ButtonBox["Cell Open",
    ButtonData:>"Cell Properties: Cell Open",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Cell Editable", "MR"],
  " (menu command)",
  ButtonBox["Cell Editable",
    ButtonData:>"Cell Properties: Cell Editable",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Cell Edit Duplicate", "MR"],
  " (menu command)",
  ButtonBox["Cell Edit Duplicate",
    ButtonData:>"Cell Properties: Cell Edit Duplicate",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Cell Evaluatable", "MR"],
  " (menu command)",
  ButtonBox["Cell Evaluatable",
    ButtonData:>"Cell Properties: Cell Evaluatable",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Cell Active", "MR"],
  " (menu command)",
  ButtonBox["Cell Active",
    ButtonData:>"Cell Properties: Cell Active",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Initialization Cell", "MR"],
  " (menu command)",
  ButtonBox["Initialization Cell",
    ButtonData:>"Cell Properties: Initialization Cell",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Cell Grouping", "MR"],
  " (menu command)"
}], "Index",
  CellTags->"Cell Grouping (menu command)"],

Cell[TextData[{
  StyleBox["Group Cells", "MR"],
  " (menu command) ",
  ButtonBox["Group Cells",
    ButtonData:>"Cell Grouping: Group Cells",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Ungroup Cells", "MR"],
  " (menu command) ",
  ButtonBox["Ungroup Cells",
    ButtonData:>"Cell Grouping: Ungroup Cells",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Manual Grouping ", "MR"],
  "(menu command) ",
  ButtonBox["Manual Grouping",
    ButtonData:>"Cell Grouping: Manual Grouping",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Automatic Grouping", "MR"],
  " (menu command) ",
  ButtonBox["Automatic Grouping",
    ButtonData:>"Cell Grouping: Automatic Grouping",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Divide Cell", "MR"],
  " (menu command) ",
  ButtonBox["Divide Cell",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Divide Cell (menu command)"],

Cell[TextData[{
  StyleBox["Merge Cells", "MR"],
  " (menu command) ",
  ButtonBox["Merge Cells",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Merge Cells (menu command)"],

Cell[TextData[{
  StyleBox["Animate Selected Graphics", "MR"],
  " (menu command) ",
  ButtonBox["Animate Selected Graphics",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Animate Selected Graphics (menu command)"],

Cell[TextData[{
  StyleBox["Play Sound", "MR"],
  " (menu command) ",
  ButtonBox["Play Sound",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Play Sound (menu command)"],

Cell[TextData[{
  StyleBox["Rerender Graphics", "MR"],
  " (menu command) ",
  ButtonBox["Rerender Graphics",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Rerender Graphics (menu command)"],

Cell[TextData[{
  StyleBox["Rerender and Save Graphics", "MR"],
  " (menu command) ",
  ButtonBox["Rerender and Save Graphics",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Rerender and Save Graphics (menu command)"],

Cell[TextData[{
  StyleBox["Make Standard Size", "MR"],
  " (menu command) ",
  ButtonBox["Make Standard Size",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Make Standard Size (menu command)"],

Cell[TextData[{
  StyleBox["Align Selected Graphics...", "MR"],
  " (menu command) ",
  ButtonBox["Align Selected Graphics...",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Align Selected Graphics (menu command)"],

Cell[TextData[{
  StyleBox["Cell Size Statistics", "MR"],
  " (menu command) ",
  ButtonBox["Cell Size Statistics",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Cell Size Statistics (menu command)"],

Cell[TextData[{
  StyleBox["Style", "MR"],
  " (menu command)"
}], "Index",
  CellTags->"Style (menu command)"],

Cell[TextData[{
  StyleBox["Styles List", "MR"],
  " (menu command) ",
  ButtonBox["Styles List",
    ButtonData:>"Style: Styles List",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Other...", "MR"],
  " (menu command) ",
  ButtonBox["Other...",
    ButtonData:>"Style: Other",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Screen Style Environment", "MR"],
  " (menu command) ",
  ButtonBox["Screen Style Environment",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Screen Style Environment (menu command)"],

Cell[TextData[{
  StyleBox["Printing Style Environment", "MR"],
  " (menu command) ",
  ButtonBox["Printing Style Environment",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Printing Style Environment (menu command)"],

Cell[TextData[{
  StyleBox["Show Expression", "MR"],
  " (menu command) ",
  ButtonBox["Show Expression",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Show Expression (menu command)"],

Cell[TextData[{
  StyleBox["Option Inspector", "MR"],
  " (menu command) ",
  ButtonBox["Option Inspector",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Option Inspector (menu command)"],

Cell[TextData[{
  StyleBox["Remove Options", "MR"],
  " (menu command) ",
  ButtonBox["Remove Options",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Remove Options (menu command)"],

Cell[TextData[{
  StyleBox["Style Sheet", "MR"],
  " (menu command) ",
  ButtonBox["Style Sheet",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Style Sheet (menu command)"],

Cell[TextData[{
  StyleBox["Edit Style Sheet", "MR"],
  " (menu command) ",
  ButtonBox["Edit Style Sheet",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Edit Style Sheet (menu command)"],

Cell[TextData[{
  StyleBox["Font", "MR"],
  " (menu command) ",
  ButtonBox["Font",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Font (menu command)"],

Cell[TextData[{
  StyleBox["Face", "MR"],
  " (menu command) ",
  ButtonBox["Face",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Face (menu command)"],

Cell[TextData[{
  StyleBox["Size", "MR"],
  " (menu command) ",
  ButtonBox["Size",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Size (menu command)"],

Cell[TextData[{
  StyleBox["Text Color", "MR"],
  " (menu command) ",
  ButtonBox["Text Color",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Text Color (menu command)"],

Cell[TextData[{
  StyleBox["Background Color", "MR"],
  " (menu command) ",
  ButtonBox["Background Color",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Background Color (menu command)"],

Cell[TextData[{
  StyleBox["Text Alignment", "MR"],
  " (menu command) ",
  ButtonBox["Text Alignment",
    ButtonData:>"Format Menu: Text Alignment",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Text Alignment (menu command)"],

Cell[TextData[{
  StyleBox["Text Justification", "MR"],
  " (menu command) ",
  ButtonBox["Text Justification",
    ButtonData:>"Format Menu: Text Justification",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Text Justification (menu command)"],

Cell[TextData[{
  StyleBox["Word Wrapping", "MR"],
  " (menu command)"
}], "Index",
  CellTags->"Word Wrapping (menu command)"],

Cell[TextData[{
  StyleBox["Don't Word Wrap", "MR"],
  " (menu command) ",
  ButtonBox["Don't Word Wrap",
    ButtonData:>"Word Wrapping: Don't Word Wrap",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Wrap at Paper Width", "MR"],
  " (menu command) ",
  ButtonBox["Wrap at Paper Width",
    ButtonData:>"Word Wrapping: Wrap at Paper Width",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Wrap at Window Width", "MR"],
  " (menu command) ",
  ButtonBox["Wrap at Window Width",
    ButtonData:>"Word Wrapping: Wrap at Window Width",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Fixed Word Wrap Width ", "MR"],
  "(menu command) ",
  ButtonBox["Fixed Word Wrap Width",
    ButtonData:>"Word Wrapping: Fixed Word Wrap Width",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Cell Dingbat", "MR"],
  " (menu command) ",
  ButtonBox["Cell Dingbat",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Cell Dingbat (menu command)"],

Cell[TextData[{
  StyleBox["Show Ruler", "MR"],
  " (menu command) ",
  ButtonBox["Show Ruler",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Show Ruler (menu command)"],

Cell[TextData[{
  StyleBox["Show Toolbar", "MR"],
  " (menu command) ",
  ButtonBox["Show Toolbar",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Show Toolbar (menu command)"],

Cell[TextData[{
  StyleBox["Show Pagebreaks", "MR"],
  " (menu command) ",
  ButtonBox["Show Pagebreaks",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Show Pagebreaks (menu command)"],

Cell[TextData[{
  StyleBox["Magnification", "MR"],
  " (menu command) ",
  ButtonBox["Magnification",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Magnification (menu command)"],

Cell[TextData[{
  StyleBox["Get Graphics Coordinates", "MR"],
  " (menu command) ",
  ButtonBox["Get Graphics Coordinates",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Get Graphics Coordinates (menu command)"],

Cell[TextData[{
  StyleBox["3D ViewPoint Selector", "MR"],
  " (menu command) ",
  ButtonBox["3D ViewPoint Selector",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"3D ViewPoint Selector (menu command)"],

Cell[TextData[{
  StyleBox["Color Selector...", "MR"],
  " (menu command) ",
  ButtonBox["Color Selector...",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Color Selector (menu command)"],

Cell[TextData[{
  StyleBox["Record Sound...", "MR"],
  " (menu command) ",
  ButtonBox["Record Sound...",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Record Sound (menu command)"],

Cell[TextData[{
  StyleBox["Get File Path...", "MR"],
  " (menu command) ",
  ButtonBox["Get File Path...",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Get File Path (menu command)"],

Cell[TextData[{
  StyleBox["Create Table/Matrix/Palette", "MR"],
  " (menu command) ",
  ButtonBox["Create Table/Matrix/Palette",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Create Table/Matrix/Palette (menu command)"],

Cell[TextData[{
  StyleBox["Create Button", "MR"],
  " (menu command) ",
  ButtonBox["Create Button",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Create Button (menu command)"],

Cell[TextData[{
  StyleBox["Edit Button", "MR"],
  " (menu command) ",
  ButtonBox["Edit Button",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Edit Button (menu command)"],

Cell[TextData[{
  StyleBox["Create Hyperlink", "MR"],
  " (menu command) ",
  ButtonBox["Create Hyperlink",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Create Hyperlink (menu command)"],

Cell[TextData[{
  StyleBox["Create Automatic Numbering Object", "MR"],
  " (menu command) ",
  ButtonBox["Create Automatic Numbering Object",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Create Automatic Numbering Object (menu command)"],

Cell[TextData[{
  StyleBox["Create Value Display Object", "MR"],
  " (menu command) ",
  ButtonBox["Create Value Display Object",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Create Value Display Object (menu command)"],

Cell[TextData[{
  StyleBox["Copy Input from Above", "MR"],
  " (menu command) ",
  ButtonBox["Copy Input from Above",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Copy Input from Above (menu command)"],

Cell[TextData[{
  StyleBox["Copy output from Above", "MR"],
  " (menu command) ",
  ButtonBox["Copy output from Above",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Copy output from Above (menu command)"],

Cell[TextData[{
  StyleBox["Start New Cell Below", "MR"],
  " (menu command) ",
  ButtonBox["Start New Cell Below",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Start New Cell Below (menu command)"],

Cell[TextData[{
  StyleBox["Complete Selection", "MR"],
  " (menu command) ",
  ButtonBox["Complete Selection",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Complete Selection (menu command)"],

Cell[TextData[{
  StyleBox["Make Template", "MR"],
  " (menu command) ",
  ButtonBox["Make Template",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Make Template (menu command)"],

Cell[TextData[{
  StyleBox["Evaluation", "MR"],
  " (menu command)"
}], "Index",
  CellTags->"Evaluation (menu command)"],

Cell[TextData[{
  StyleBox["Evaluate Cells", "MR"],
  " (menu command) ",
  ButtonBox["Evaluate Cells",
    ButtonData:>"Evaluation: Evaluate Cells",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Evaluate In Place", "MR"],
  " (menu command) ",
  ButtonBox["Evaluate In Place",
    ButtonData:>"Evaluation: Evaluate In Place",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Evaluate Next Input", "MR"],
  " (menu command) ",
  ButtonBox["Evaluate Next Input",
    ButtonData:>"Evaluation: Evaluate Next Input",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Evaluate In Subsession", "MR"],
  " (menu command) ",
  ButtonBox["Evaluate In Subsession",
    ButtonData:>"Evaluation: Evaluate In Subsession",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Evaluate Notebook", "MR"],
  " (menu command) ",
  ButtonBox["Evaluate Notebook",
    ButtonData:>"Evaluation: Evaluate Notebook",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Evaluate initialization", "MR"],
  " (menu command) ",
  ButtonBox["Evaluate Initialization",
    ButtonData:>"Evaluation: Evaluate Initialization",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Enter Subsession", "MR"],
  " (menu command) ",
  ButtonBox["Enter Subsession",
    ButtonData:>"Evaluation: Enter Subsession",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Exit Subsession", "MR"],
  " (menu command) ",
  ButtonBox["Exit Subsession",
    ButtonData:>"Evaluation: Exit Subsession",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Remove from Evaluation Queue", "MR"],
  " (menu command) ",
  ButtonBox["Remove from Evaluation Queue",
    ButtonData:>"Evaluation: Remove from Evaluation Queue",
    ButtonStyle->"OtherInformationLink"]
}], "IndexSubentry",
  ShowCellBracket->False,
  CellTags->"menucommands"],

Cell[TextData[{
  StyleBox["Interrupt Evaluation", "MR"],
  " (menu command) ",
  ButtonBox["Interrupt Evaluation",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Interrupt Evaluation (menu command)"],

Cell[TextData[{
  StyleBox["Abort Evaluation", "MR"],
  " (menu command) ",
  ButtonBox["Abort Evaluation",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Abort Evaluation (menu command)"],

Cell[TextData[{
  StyleBox["Start Kernel", "MR"],
  " (menu command) ",
  ButtonBox["Start Kernel",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Start Kernel (menu command)"],

Cell[TextData[{
  StyleBox["Quit Kernel", "MR"],
  " (menu command) ",
  ButtonBox["Quit Kernel",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Quit Kernel (menu command)"],

Cell[TextData[{
  StyleBox["Default Kernel", "MR"],
  " (menu command) ",
  ButtonBox["Default Kernel",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Default Kernel (menu command)"],

Cell[TextData[{
  StyleBox["Notebook's Kernel", "MR"],
  " (menu command) ",
  ButtonBox["Notebook's Kernel",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Notebook's Kernel (menu command)"],

Cell[TextData[{
  StyleBox["Open Terminal Window", "MR"],
  " (menu command) ",
  ButtonBox["Open Terminal Window",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Open Terminal Window (menu command)"],

Cell[TextData[{
  StyleBox["Kernel Configuration Options", "MR"],
  " (menu command) ",
  ButtonBox["Kernel Configuration Options",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Kernel Configuration Options (menu command)"],

Cell[TextData[{
  StyleBox["Show In/Out Names", "MR"],
  " (menu command) ",
  ButtonBox["Show In/Out Names",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Show In/Out Names (menu command)"],

Cell[TextData[{
  StyleBox["Delete All Output", "MR"],
  " (menu command) ",
  ButtonBox["Delete All Output",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Delete All Output (menu command)"],

Cell[TextData[{
  StyleBox["Find", "MR"],
  " (menu command) ",
  ButtonBox["Find",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Find (menu command)"],

Cell[TextData[{
  StyleBox["Enter Selection", "MR"],
  " (menu command) ",
  ButtonBox["Enter Selection",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Enter Selection (menu command)"],

Cell[TextData[{
  StyleBox["Find Next", "MR"],
  " (menu command) ",
  ButtonBox["Find Next",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Find Next (menu command)"],

Cell[TextData[{
  StyleBox["Find Previous", "MR"],
  " (menu command) ",
  ButtonBox["Find Previous",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Find Previous (menu command)"],

Cell[TextData[{
  StyleBox["Find in Cell Tags", "MR"],
  " (menu command) ",
  ButtonBox["Find in Cell Tags",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Find in Cell Tags (menu command)"],

Cell[TextData[{
  StyleBox["Replace", "MR"],
  " (menu command) ",
  ButtonBox["Replace",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Replace (menu command)"],

Cell[TextData[{
  StyleBox["Replace and Find Again", "MR"],
  " (menu command) ",
  ButtonBox["Replace and Find Again",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Replace and Find Again (menu command)"],

Cell[TextData[{
  StyleBox["Replace All", "MR"],
  " (menu command) ",
  ButtonBox["Replace All",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Replace All (menu command)"],

Cell[TextData[{
  StyleBox["Open Selected", "MR"],
  " (menu command) ",
  ButtonBox["Open Selected",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Open Selected (menu command)"],

Cell[TextData[{
  StyleBox["Scroll to Selection", "MR"],
  " (menu command) ",
  ButtonBox["Scroll to Selection",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Scroll to Selection (menu command)"],

Cell[TextData[{
  StyleBox["Go Back", "MR"],
  " (menu command) ",
  ButtonBox["Go Back",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Go Back (menu command)"],

Cell[TextData[{
  StyleBox["Add/Remove Cell Tags", "MR"],
  " (menu command) ",
  ButtonBox["Add/Remove Cell Tags",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Add/Remove Cell Tags (menu command)"],

Cell[TextData[{
  StyleBox["Cell Tags", "MR"],
  " (menu command) ",
  ButtonBox["Cell Tags",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Cell Tags (menu command)"],

Cell[TextData[{
  StyleBox["Show Cell Tags", "MR"],
  " (menu command) ",
  ButtonBox["Show Cell Tags",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Show Cell Tags (menu command)"],

Cell[TextData[{
  StyleBox["Cell Tags from In/Out Names", "MR"],
  " (menu command) ",
  ButtonBox["Cell Tags from In/Out Names",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Cell Tags from In/Out Names (menu command)"],

Cell[TextData[{
  StyleBox["Make Index", "MR"],
  " (menu command) ",
  ButtonBox["Make Index",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Make Index... (menu command)"],

Cell[TextData[{
  StyleBox["Stack Windows", "MR"],
  " (menu command) ",
  ButtonBox["Stack Windows",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Stack Windows (menu command)"],

Cell[TextData[{
  StyleBox["Tile Windows Wide", "MR"],
  " (menu command) ",
  ButtonBox["Tile Windows Wide",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Tile Windows Wide (menu command)"],

Cell[TextData[{
  StyleBox["Tile Windows Tall", "MR"],
  " (menu command) ",
  ButtonBox["Tile Windows Tall",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Tile Windows Tall (menu command)"],

Cell[TextData[{
  StyleBox["Help...", "MR"],
  " (menu command) ",
  ButtonBox["Help...",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Help (menu command)"],

Cell[TextData[{
  StyleBox["Find in Help...", "MR"],
  " (menu command) ",
  ButtonBox["Find in Help...",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Find in Help (menu command)"],

Cell[TextData[{
  StyleBox["Why the Beep?...", "MR"],
  " (menu command) ",
  ButtonBox["Why the Beep?...",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Why the Beep? (menu command)"],

Cell[TextData[{
  StyleBox["Rebuild Help Index", "MR"],
  " (menu command) ",
  ButtonBox["Rebuild Help Index",
    ButtonStyle->"OtherInformationLink"]
}], "Index",
  CellTags->"Rebuild Help Index (menu command)"],

Cell[" Keyboard Shortcuts ", "IndexSection"],

Cell[TextData[{
  StyleBox["Keyboard Shortcuts ", "MR"],
  "\n",
  "    ",
  ButtonBox["on Microsoft Windows",
    ButtonData:>"Windows Keyboard Shortcuts",
    ButtonStyle->"OtherInformationLink"],
  "\n",
  "    ",
  ButtonBox["on Macintosh",
    ButtonData:>"Macintosh Keyboard Shortcuts",
    ButtonStyle->"OtherInformationLink"],
  "\n",
  "    ",
  ButtonBox["on NEXTSTEP",
    ButtonData:>"NEXTSTEP Keyboard Shortcuts",
    ButtonStyle->"OtherInformationLink"],
  "\n",
  "    ",
  ButtonBox["on X",
    ButtonData:>"X Keyboard Shortcuts",
    ButtonStyle->"OtherInformationLink"],
  "\n"
}], "Index",
  CellTags->"Keyboard shortcuts"],

Cell[" Style sheets ", "IndexSection"],

Cell[TextData[{
  "Style sheets, changing the default,  ",
  ButtonBox["Changing default style sheets",
    ButtonStyle->"OtherInformationLink"],
  "\n\tcreating, ",
  ButtonBox["Create a style sheet",
    ButtonStyle->"OtherInformationLink"],
  "\n\tdefault,  ",
  ButtonBox["What is the default style sheet? ",
    ButtonStyle->"OtherInformationLink"],
  "\n\tediting, ",
  ButtonBox["Editing a style sheet",
    ButtonStyle->"OtherInformationLink"],
  "\n\tintroduction, ",
  ButtonBox["What is a style sheet?",
    ButtonStyle->"OtherInformationLink"],
  "\n\tenvironments, ",
  ButtonBox["What are environments?",
    ButtonStyle->"OtherInformationLink"],
  "\n\t\n\t"
}], "Index",
  CellTags->{"Style sheets", "Environments"}]
},
FrontEndVersion->"NeXT 3.0",
ScreenRectangle->{{0, 1053}, {0, 832}},
WindowToolbars->"EditBar",
WindowSize->{520, 574},
WindowMargins->{{179, Automatic}, {Automatic, 1}},
Visible->True,
StyleDefinitions -> "HelpBrowser.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "MasterIndexHeading"->{
    Cell[1709, 49, 75, 1, 39, "IndexSection",
      CellTags->"MasterIndexHeading"]},
  "New (menu command)"->{
    Cell[1829, 54, 169, 6, 14, "Index",
      CellTags->"New (menu command)"]},
  "Open (menu command)"->{
    Cell[2001, 62, 178, 6, 14, "Index",
      CellTags->"Open (menu command)"]},
  "Close (menu command)"->{
    Cell[2182, 70, 175, 6, 14, "Index",
      CellTags->"Close (menu command)"]},
  "Save (menu command)"->{
    Cell[2360, 78, 172, 6, 14, "Index",
      CellTags->"Save (menu command)"]},
  "Save As (menu command)"->{
    Cell[2535, 86, 187, 6, 14, "Index",
      CellTags->"Save As (menu command)"]},
  "Save As Special (menu command)"->{
    Cell[2725, 94, 211, 6, 14, "Index",
      CellTags->"Save As Special (menu command)"]},
  "menucommands"->{
    Cell[2939, 102, 276, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[3218, 112, 240, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[3461, 122, 270, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[3734, 132, 282, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[4019, 142, 270, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[4292, 152, 237, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[4532, 162, 239, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[4774, 172, 181, 6, 14, "Index",
      CellTags->"menucommands"],
    Cell[4958, 180, 185, 6, 14, "Index",
      CellTags->"menucommands"],
    Cell[6213, 228, 137, 5, 14, "Index",
      CellTags->"menucommands"],
    Cell[6353, 235, 260, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[6616, 245, 278, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[6897, 255, 287, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[9839, 377, 304, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[10146, 387, 292, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[11718, 451, 250, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[11971, 461, 259, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[12233, 471, 268, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[12504, 481, 253, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[12760, 491, 241, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[13004, 501, 235, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[13242, 511, 253, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[13498, 521, 271, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[13772, 531, 250, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[14149, 547, 235, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[14387, 557, 238, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[14628, 567, 259, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[14890, 577, 268, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[15313, 593, 264, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[15580, 603, 273, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[15856, 613, 282, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[16295, 629, 268, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[16566, 639, 265, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[16834, 649, 274, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[17111, 659, 283, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[17551, 675, 274, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[17828, 685, 283, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[18248, 701, 255, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[18506, 711, 266, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[18775, 721, 284, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[19062, 731, 275, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[19340, 741, 260, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[19603, 751, 284, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[20020, 767, 259, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[20282, 777, 265, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[20550, 787, 271, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[20824, 797, 280, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[23177, 885, 251, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[23431, 895, 239, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[26759, 1025, 271, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[27033, 1035, 283, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[27319, 1045, 286, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[27608, 1055, 289, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[32566, 1239, 265, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[32834, 1249, 274, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[33111, 1259, 280, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[33394, 1269, 289, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[33686, 1279, 274, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[33963, 1289, 292, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[34258, 1299, 271, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[34532, 1309, 268, 8, 14, "IndexSubentry",
      CellTags->"menucommands"],
    Cell[34803, 1319, 307, 8, 14, "IndexSubentry",
      CellTags->"menucommands"]},
  "Import (menu command)"->{
    Cell[5146, 188, 178, 6, 14, "Index",
      CellTags->"Import (menu command)"]},
  "Palettes (menu command)"->{
    Cell[5327, 196, 184, 6, 14, "Index",
      CellTags->"Palettes (menu command)"]},
  "Notebooks (menu command)"->{
    Cell[5514, 204, 187, 6, 14, "Index",
      CellTags->"Notebooks (menu command)"]},
  "Generate Palette from Selection (menu command)"->{
    Cell[5704, 212, 253, 6, 14, "Index",
      CellTags->"Generate Palette from Selection (menu command)"]},
  "Generate Notebook from Palette (menu command)"->{
    Cell[5960, 220, 250, 6, 14, "Index",
      CellTags->"Generate Notebook from Palette (menu command)"]},
  "Print... (menu command)"->{
    Cell[7187, 265, 184, 6, 14, "Index",
      CellTags->"Print... (menu command)"]},
  "Print Selection (menu command)"->{
    Cell[7374, 273, 205, 6, 14, "Index",
      CellTags->"Print Selection (menu command)"]},
  "Quit (menu command)"->{
    Cell[7582, 281, 173, 6, 14, "Index",
      CellTags->"Quit (menu command)"]},
  "Undo (menu command)"->{
    Cell[7758, 289, 172, 6, 14, "Index",
      CellTags->"Undo (menu command)"]},
  "Cut (menu command)"->{
    Cell[7933, 297, 169, 6, 14, "Index",
      CellTags->"Cut (menu command)"]},
  "Copy (menu command)"->{
    Cell[8105, 305, 172, 6, 14, "Index",
      CellTags->"Copy (menu command)"]},
  "Paste (menu command)"->{
    Cell[8280, 313, 175, 6, 14, "Index",
      CellTags->"Paste (menu command)"]},
  "Clear (menu command)"->{
    Cell[8458, 321, 175, 6, 14, "Index",
      CellTags->"Clear (menu command)"]},
  "Paste and Discard (menu command)"->{
    Cell[8636, 329, 211, 6, 14, "Index",
      CellTags->"Paste and Discard (menu command)"]},
  "Copy As (menu command)"->{
    Cell[8850, 337, 181, 6, 14, "Index",
      CellTags->"Copy As (menu command)"]},
  "Save Selection As (menu command)"->{
    Cell[9034, 345, 217, 6, 14, "Index",
      CellTags->"Save Selection As (menu command)"]},
  "Select All (menu command)"->{
    Cell[9254, 353, 190, 6, 14, "Index",
      CellTags->"Select All (menu command)"]},
  "Motion (menu command)"->{
    Cell[9447, 361, 178, 6, 14, "Index",
      CellTags->"Motion (menu command)"]},
  "Expression Input (menu command)"->{
    Cell[9628, 369, 208, 6, 14, "Index",
      CellTags->"Expression Input (menu command)"]},
  "Make 2D (menu command)"->{
    Cell[10441, 397, 181, 6, 14, "Index",
      CellTags->"Make 2D (menu command)"]},
  "Check Balance (menu command)"->{
    Cell[10625, 405, 199, 6, 14, "Index",
      CellTags->"Check Balance (menu command)"]},
  "Shift Left (menu command)"->{
    Cell[10827, 413, 191, 6, 14, "Index",
      CellTags->"Shift Left (menu command)"]},
  "Shift Right (menu command)"->{
    Cell[11021, 421, 193, 6, 14, "Index",
      CellTags->"Shift Right (menu command)"]},
  "Preferences (menu command)"->{
    Cell[11217, 429, 199, 6, 14, "Index",
      CellTags->"Preferences (menu command)"]},
  "Cell (menu command)"->{
    Cell[11419, 437, 172, 6, 14, "Index",
      CellTags->"Cell (menu command)"]},
  "Convert To (menu command)"->{
    Cell[11594, 445, 121, 4, 14, "Index",
      CellTags->"Convert To (menu command)"]},
  "Display As (menu command)"->{
    Cell[14025, 541, 121, 4, 14, "Index",
      CellTags->"Display As (menu command)"]},
  "Default Input FormatType (menu command)"->{
    Cell[15161, 587, 149, 4, 14, "Index",
      CellTags->"Default Input FormatType (menu command)"]},
  "Default Output FormatType (menu command)"->{
    Cell[16141, 623, 151, 4, 14, "Index",
      CellTags->"Default Output FormatType (menu command)"]},
  "Default Inline FormatType (menu command)"->{
    Cell[17397, 669, 151, 4, 14, "Index",
      CellTags->"Default Inline FormatType (menu command)"]},
  "Cell Properties (menu command)"->{
    Cell[18114, 695, 131, 4, 14, "Index",
      CellTags->"Cell Properties (menu command)"]},
  "Cell Grouping (menu command)"->{
    Cell[19890, 761, 127, 4, 14, "Index",
      CellTags->"Cell Grouping (menu command)"]},
  "Divide Cell (menu command)"->{
    Cell[21107, 807, 193, 6, 14, "Index",
      CellTags->"Divide Cell (menu command)"]},
  "Merge Cells (menu command)"->{
    Cell[21303, 815, 193, 6, 14, "Index",
      CellTags->"Merge Cells (menu command)"]},
  "Animate Selected Graphics (menu command)"->{
    Cell[21499, 823, 235, 6, 14, "Index",
      CellTags->"Animate Selected Graphics (menu command)"]},
  "Play Sound (menu command)"->{
    Cell[21737, 831, 190, 6, 14, "Index",
      CellTags->"Play Sound (menu command)"]},
  "Rerender Graphics (menu command)"->{
    Cell[21930, 839, 211, 6, 14, "Index",
      CellTags->"Rerender Graphics (menu command)"]},
  "Rerender and Save Graphics (menu command)"->{
    Cell[22144, 847, 238, 6, 14, "Index",
      CellTags->"Rerender and Save Graphics (menu command)"]},
  "Make Standard Size (menu command)"->{
    Cell[22385, 855, 214, 6, 14, "Index",
      CellTags->"Make Standard Size (menu command)"]},
  "Align Selected Graphics (menu command)"->{
    Cell[22602, 863, 235, 6, 14, "Index",
      CellTags->"Align Selected Graphics (menu command)"]},
  "Cell Size Statistics (menu command)"->{
    Cell[22840, 871, 220, 6, 14, "Index",
      CellTags->"Cell Size Statistics (menu command)"]},
  "Style (menu command)"->{
    Cell[23063, 879, 111, 4, 14, "Index",
      CellTags->"Style (menu command)"]},
  "Screen Style Environment (menu command)"->{
    Cell[23673, 905, 232, 6, 14, "Index",
      CellTags->"Screen Style Environment (menu command)"]},
  "Printing Style Environment (menu command)"->{
    Cell[23908, 913, 238, 6, 14, "Index",
      CellTags->"Printing Style Environment (menu command)"]},
  "Show Expression (menu command)"->{
    Cell[24149, 921, 205, 6, 14, "Index",
      CellTags->"Show Expression (menu command)"]},
  "Option Inspector (menu command)"->{
    Cell[24357, 929, 208, 6, 14, "Index",
      CellTags->"Option Inspector (menu command)"]},
  "Remove Options (menu command)"->{
    Cell[24568, 937, 202, 6, 14, "Index",
      CellTags->"Remove Options (menu command)"]},
  "Style Sheet (menu command)"->{
    Cell[24773, 945, 193, 6, 14, "Index",
      CellTags->"Style Sheet (menu command)"]},
  "Edit Style Sheet (menu command)"->{
    Cell[24969, 953, 208, 6, 14, "Index",
      CellTags->"Edit Style Sheet (menu command)"]},
  "Font (menu command)"->{
    Cell[25180, 961, 172, 6, 14, "Index",
      CellTags->"Font (menu command)"]},
  "Face (menu command)"->{
    Cell[25355, 969, 172, 6, 14, "Index",
      CellTags->"Face (menu command)"]},
  "Size (menu command)"->{
    Cell[25530, 977, 172, 6, 14, "Index",
      CellTags->"Size (menu command)"]},
  "Text Color (menu command)"->{
    Cell[25705, 985, 190, 6, 14, "Index",
      CellTags->"Text Color (menu command)"]},
  "Background Color (menu command)"->{
    Cell[25898, 993, 208, 6, 14, "Index",
      CellTags->"Background Color (menu command)"]},
  "Text Alignment (menu command)"->{
    Cell[26109, 1001, 249, 7, 14, "Index",
      CellTags->"Text Alignment (menu command)"]},
  "Text Justification (menu command)"->{
    Cell[26361, 1010, 265, 7, 14, "Index",
      CellTags->"Text Justification (menu command)"]},
  "Word Wrapping (menu command)"->{
    Cell[26629, 1019, 127, 4, 14, "Index",
      CellTags->"Word Wrapping (menu command)"]},
  "Cell Dingbat (menu command)"->{
    Cell[27900, 1065, 196, 6, 14, "Index",
      CellTags->"Cell Dingbat (menu command)"]},
  "Show Ruler (menu command)"->{
    Cell[28099, 1073, 190, 6, 14, "Index",
      CellTags->"Show Ruler (menu command)"]},
  "Show Toolbar (menu command)"->{
    Cell[28292, 1081, 196, 6, 14, "Index",
      CellTags->"Show Toolbar (menu command)"]},
  "Show Pagebreaks (menu command)"->{
    Cell[28491, 1089, 205, 6, 14, "Index",
      CellTags->"Show Pagebreaks (menu command)"]},
  "Magnification (menu command)"->{
    Cell[28699, 1097, 199, 6, 14, "Index",
      CellTags->"Magnification (menu command)"]},
  "Get Graphics Coordinates (menu command)"->{
    Cell[28901, 1105, 232, 6, 14, "Index",
      CellTags->"Get Graphics Coordinates (menu command)"]},
  "3D ViewPoint Selector (menu command)"->{
    Cell[29136, 1113, 223, 6, 14, "Index",
      CellTags->"3D ViewPoint Selector (menu command)"]},
  "Color Selector (menu command)"->{
    Cell[29362, 1121, 208, 6, 14, "Index",
      CellTags->"Color Selector (menu command)"]},
  "Record Sound (menu command)"->{
    Cell[29573, 1129, 202, 6, 14, "Index",
      CellTags->"Record Sound (menu command)"]},
  "Get File Path (menu command)"->{
    Cell[29778, 1137, 205, 6, 14, "Index",
      CellTags->"Get File Path (menu command)"]},
  "Create Table/Matrix/Palette (menu command)"->{
    Cell[29986, 1145, 241, 6, 14, "Index",
      CellTags->"Create Table/Matrix/Palette (menu command)"]},
  "Create Button (menu command)"->{
    Cell[30230, 1153, 199, 6, 14, "Index",
      CellTags->"Create Button (menu command)"]},
  "Edit Button (menu command)"->{
    Cell[30432, 1161, 193, 6, 14, "Index",
      CellTags->"Edit Button (menu command)"]},
  "Create Hyperlink (menu command)"->{
    Cell[30628, 1169, 208, 6, 14, "Index",
      CellTags->"Create Hyperlink (menu command)"]},
  "Create Automatic Numbering Object (menu command)"->{
    Cell[30839, 1177, 259, 6, 28, "Index",
      CellTags->"Create Automatic Numbering Object (menu command)"]},
  "Create Value Display Object (menu command)"->{
    Cell[31101, 1185, 241, 6, 14, "Index",
      CellTags->"Create Value Display Object (menu command)"]},
  "Copy Input from Above (menu command)"->{
    Cell[31345, 1193, 223, 6, 14, "Index",
      CellTags->"Copy Input from Above (menu command)"]},
  "Copy output from Above (menu command)"->{
    Cell[31571, 1201, 226, 6, 14, "Index",
      CellTags->"Copy output from Above (menu command)"]},
  "Start New Cell Below (menu command)"->{
    Cell[31800, 1209, 220, 6, 14, "Index",
      CellTags->"Start New Cell Below (menu command)"]},
  "Complete Selection (menu command)"->{
    Cell[32023, 1217, 214, 6, 14, "Index",
      CellTags->"Complete Selection (menu command)"]},
  "Make Template (menu command)"->{
    Cell[32240, 1225, 199, 6, 14, "Index",
      CellTags->"Make Template (menu command)"]},
  "Evaluation (menu command)"->{
    Cell[32442, 1233, 121, 4, 14, "Index",
      CellTags->"Evaluation (menu command)"]},
  "Interrupt Evaluation (menu command)"->{
    Cell[35113, 1329, 220, 6, 14, "Index",
      CellTags->"Interrupt Evaluation (menu command)"]},
  "Abort Evaluation (menu command)"->{
    Cell[35336, 1337, 208, 6, 14, "Index",
      CellTags->"Abort Evaluation (menu command)"]},
  "Start Kernel (menu command)"->{
    Cell[35547, 1345, 196, 6, 14, "Index",
      CellTags->"Start Kernel (menu command)"]},
  "Quit Kernel (menu command)"->{
    Cell[35746, 1353, 193, 6, 14, "Index",
      CellTags->"Quit Kernel (menu command)"]},
  "Default Kernel (menu command)"->{
    Cell[35942, 1361, 202, 6, 14, "Index",
      CellTags->"Default Kernel (menu command)"]},
  "Notebook's Kernel (menu command)"->{
    Cell[36147, 1369, 211, 6, 14, "Index",
      CellTags->"Notebook's Kernel (menu command)"]},
  "Open Terminal Window (menu command)"->{
    Cell[36361, 1377, 220, 6, 14, "Index",
      CellTags->"Open Terminal Window (menu command)"]},
  "Kernel Configuration Options (menu command)"->{
    Cell[36584, 1385, 244, 6, 14, "Index",
      CellTags->"Kernel Configuration Options (menu command)"]},
  "Show In/Out Names (menu command)"->{
    Cell[36831, 1393, 211, 6, 14, "Index",
      CellTags->"Show In/Out Names (menu command)"]},
  "Delete All Output (menu command)"->{
    Cell[37045, 1401, 211, 6, 14, "Index",
      CellTags->"Delete All Output (menu command)"]},
  "Find (menu command)"->{
    Cell[37259, 1409, 172, 6, 14, "Index",
      CellTags->"Find (menu command)"]},
  "Enter Selection (menu command)"->{
    Cell[37434, 1417, 205, 6, 14, "Index",
      CellTags->"Enter Selection (menu command)"]},
  "Find Next (menu command)"->{
    Cell[37642, 1425, 187, 6, 14, "Index",
      CellTags->"Find Next (menu command)"]},
  "Find Previous (menu command)"->{
    Cell[37832, 1433, 199, 6, 14, "Index",
      CellTags->"Find Previous (menu command)"]},
  "Find in Cell Tags (menu command)"->{
    Cell[38034, 1441, 211, 6, 14, "Index",
      CellTags->"Find in Cell Tags (menu command)"]},
  "Replace (menu command)"->{
    Cell[38248, 1449, 181, 6, 14, "Index",
      CellTags->"Replace (menu command)"]},
  "Replace and Find Again (menu command)"->{
    Cell[38432, 1457, 226, 6, 14, "Index",
      CellTags->"Replace and Find Again (menu command)"]},
  "Replace All (menu command)"->{
    Cell[38661, 1465, 193, 6, 14, "Index",
      CellTags->"Replace All (menu command)"]},
  "Open Selected (menu command)"->{
    Cell[38857, 1473, 199, 6, 14, "Index",
      CellTags->"Open Selected (menu command)"]},
  "Scroll to Selection (menu command)"->{
    Cell[39059, 1481, 217, 6, 14, "Index",
      CellTags->"Scroll to Selection (menu command)"]},
  "Go Back (menu command)"->{
    Cell[39279, 1489, 181, 6, 14, "Index",
      CellTags->"Go Back (menu command)"]},
  "Add/Remove Cell Tags (menu command)"->{
    Cell[39463, 1497, 220, 6, 14, "Index",
      CellTags->"Add/Remove Cell Tags (menu command)"]},
  "Cell Tags (menu command)"->{
    Cell[39686, 1505, 187, 6, 14, "Index",
      CellTags->"Cell Tags (menu command)"]},
  "Show Cell Tags (menu command)"->{
    Cell[39876, 1513, 202, 6, 14, "Index",
      CellTags->"Show Cell Tags (menu command)"]},
  "Cell Tags from In/Out Names (menu command)"->{
    Cell[40081, 1521, 241, 6, 14, "Index",
      CellTags->"Cell Tags from In/Out Names (menu command)"]},
  "Make Index... (menu command)"->{
    Cell[40325, 1529, 193, 6, 14, "Index",
      CellTags->"Make Index... (menu command)"]},
  "Stack Windows (menu command)"->{
    Cell[40521, 1537, 199, 6, 14, "Index",
      CellTags->"Stack Windows (menu command)"]},
  "Tile Windows Wide (menu command)"->{
    Cell[40723, 1545, 211, 6, 14, "Index",
      CellTags->"Tile Windows Wide (menu command)"]},
  "Tile Windows Tall (menu command)"->{
    Cell[40937, 1553, 211, 6, 14, "Index",
      CellTags->"Tile Windows Tall (menu command)"]},
  "Help (menu command)"->{
    Cell[41151, 1561, 178, 6, 14, "Index",
      CellTags->"Help (menu command)"]},
  "Find in Help (menu command)"->{
    Cell[41332, 1569, 202, 6, 14, "Index",
      CellTags->"Find in Help (menu command)"]},
  "Why the Beep? (menu command)"->{
    Cell[41537, 1577, 205, 6, 14, "Index",
      CellTags->"Why the Beep? (menu command)"]},
  "Rebuild Help Index (menu command)"->{
    Cell[41745, 1585, 214, 6, 14, "Index",
      CellTags->"Rebuild Help Index (menu command)"]},
  "Keyboard shortcuts"->{
    Cell[42009, 1595, 642, 24, 82, "Index",
      CellTags->"Keyboard shortcuts"]},
  "Style sheets"->{
    Cell[42695, 1623, 732, 21, 112, "Index",
      CellTags->{"Style sheets", "Environments"}]},
  "Environments"->{
    Cell[42695, 1623, 732, 21, 112, "Index",
      CellTags->{"Style sheets", "Environments"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"MasterIndexHeading", 44108, 1665},
  {"New (menu command)", 44220, 1668},
  {"Open (menu command)", 44327, 1671},
  {"Close (menu command)", 44436, 1674},
  {"Save (menu command)", 44545, 1677},
  {"Save As (menu command)", 44656, 1680},
  {"Save As Special (menu command)", 44778, 1683},
  {"menucommands", 44890, 1686},
  {"Import (menu command)", 50041, 1811},
  {"Palettes (menu command)", 50156, 1814},
  {"Notebooks (menu command)", 50274, 1817},
  {"Generate Palette from Selection (menu command)", 50415, 1820},
  {"Generate Notebook from Palette (menu command)", 50577, 1823},
  {"Print... (menu command)", 50716, 1826},
  {"Print Selection (menu command)", 50840, 1829},
  {"Quit (menu command)", 50960, 1832},
  {"Undo (menu command)", 51069, 1835},
  {"Cut (menu command)", 51177, 1838},
  {"Copy (menu command)", 51285, 1841},
  {"Paste (menu command)", 51395, 1844},
  {"Clear (menu command)", 51506, 1847},
  {"Paste and Discard (menu command)", 51629, 1850},
  {"Copy As (menu command)", 51754, 1853},
  {"Save Selection As (menu command)", 51879, 1856},
  {"Select All (menu command)", 52007, 1859},
  {"Motion (menu command)", 52124, 1862},
  {"Expression Input (menu command)", 52247, 1865},
  {"Make 2D (menu command)", 52371, 1868},
  {"Check Balance (menu command)", 52493, 1871},
  {"Shift Left (menu command)", 52618, 1874},
  {"Shift Right (menu command)", 52741, 1877},
  {"Preferences (menu command)", 52865, 1880},
  {"Cell (menu command)", 52982, 1883},
  {"Convert To (menu command)", 53098, 1886},
  {"Display As (menu command)", 53220, 1889},
  {"Default Input FormatType (menu command)", 53356, 1892},
  {"Default Output FormatType (menu command)", 53507, 1895},
  {"Default Inline FormatType (menu command)", 53659, 1898},
  {"Cell Properties (menu command)", 53801, 1901},
  {"Cell Grouping (menu command)", 53931, 1904},
  {"Divide Cell (menu command)", 54057, 1907},
  {"Merge Cells (menu command)", 54181, 1910},
  {"Animate Selected Graphics (menu command)", 54319, 1913},
  {"Play Sound (menu command)", 54456, 1916},
  {"Rerender Graphics (menu command)", 54585, 1919},
  {"Rerender and Save Graphics (menu command)", 54730, 1922},
  {"Make Standard Size (menu command)", 54876, 1925},
  {"Align Selected Graphics (menu command)", 55019, 1928},
  {"Cell Size Statistics (menu command)", 55164, 1931},
  {"Style (menu command)", 55291, 1934},
  {"Screen Style Environment (menu command)", 55422, 1937},
  {"Printing Style Environment (menu command)", 55574, 1940},
  {"Show Expression (menu command)", 55717, 1943},
  {"Option Inspector (menu command)", 55850, 1946},
  {"Remove Options (menu command)", 55982, 1949},
  {"Style Sheet (menu command)", 56109, 1952},
  {"Edit Style Sheet (menu command)", 56238, 1955},
  {"Font (menu command)", 56360, 1958},
  {"Face (menu command)", 56470, 1961},
  {"Size (menu command)", 56580, 1964},
  {"Text Color (menu command)", 56696, 1967},
  {"Background Color (menu command)", 56824, 1970},
  {"Text Alignment (menu command)", 56956, 1973},
  {"Text Justification (menu command)", 57091, 1976},
  {"Word Wrapping (menu command)", 57225, 1979},
  {"Cell Dingbat (menu command)", 57353, 1982},
  {"Show Ruler (menu command)", 57478, 1985},
  {"Show Toolbar (menu command)", 57603, 1988},
  {"Show Pagebreaks (menu command)", 57733, 1991},
  {"Magnification (menu command)", 57864, 1994},
  {"Get Graphics Coordinates (menu command)", 58004, 1997},
  {"3D ViewPoint Selector (menu command)", 58152, 2000},
  {"Color Selector (menu command)", 58290, 2003},
  {"Record Sound (menu command)", 58419, 2006},
  {"Get File Path (menu command)", 58547, 2009},
  {"Create Table/Matrix/Palette (menu command)", 58690, 2012},
  {"Create Button (menu command)", 58833, 2015},
  {"Edit Button (menu command)", 58960, 2018},
  {"Create Hyperlink (menu command)", 59090, 2021},
  {"Create Automatic Numbering Object (menu command)", 59242, 2024},
  {"Create Value Display Object (menu command)", 59405, 2027},
  {"Copy Input from Above (menu command)", 59556, 2030},
  {"Copy output from Above (menu command)", 59702, 2033},
  {"Start New Cell Below (menu command)", 59847, 2036},
  {"Complete Selection (menu command)", 59988, 2039},
  {"Make Template (menu command)", 60122, 2042},
  {"Evaluation (menu command)", 60248, 2045},
  {"Interrupt Evaluation (menu command)", 60381, 2048},
  {"Abort Evaluation (menu command)", 60520, 2051},
  {"Start Kernel (menu command)", 60651, 2054},
  {"Quit Kernel (menu command)", 60777, 2057},
  {"Default Kernel (menu command)", 60905, 2060},
  {"Notebook's Kernel (menu command)", 61039, 2063},
  {"Open Terminal Window (menu command)", 61179, 2066},
  {"Kernel Configuration Options (menu command)", 61330, 2069},
  {"Show In/Out Names (menu command)", 61478, 2072},
  {"Delete All Output (menu command)", 61615, 2075},
  {"Find (menu command)", 61739, 2078},
  {"Enter Selection (menu command)", 61861, 2081},
  {"Find Next (menu command)", 61988, 2084},
  {"Find Previous (menu command)", 62113, 2087},
  {"Find in Cell Tags (menu command)", 62246, 2090},
  {"Replace (menu command)", 62373, 2093},
  {"Replace and Find Again (menu command)", 62505, 2096},
  {"Replace All (menu command)", 62641, 2099},
  {"Open Selected (menu command)", 62768, 2102},
  {"Scroll to Selection (menu command)", 62903, 2105},
  {"Go Back (menu command)", 63032, 2108},
  {"Add/Remove Cell Tags (menu command)", 63162, 2111},
  {"Cell Tags (menu command)", 63294, 2114},
  {"Show Cell Tags (menu command)", 63420, 2117},
  {"Cell Tags from In/Out Names (menu command)", 63564, 2120},
  {"Make Index... (menu command)", 63707, 2123},
  {"Stack Windows (menu command)", 63836, 2126},
  {"Tile Windows Wide (menu command)", 63969, 2129},
  {"Tile Windows Tall (menu command)", 64106, 2132},
  {"Help (menu command)", 64230, 2135},
  {"Find in Help (menu command)", 64349, 2138},
  {"Why the Beep? (menu command)", 64477, 2141},
  {"Rebuild Help Index (menu command)", 64611, 2144},
  {"Keyboard shortcuts", 64735, 2147},
  {"Style sheets", 64839, 2150},
  {"Environments", 64956, 2153}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 75, 1, 39, "IndexSection",
  CellTags->"MasterIndexHeading"],
Cell[1787, 52, 39, 0, 39, "IndexSection"],
Cell[1829, 54, 169, 6, 14, "Index",
  CellTags->"New (menu command)"],
Cell[2001, 62, 178, 6, 14, "Index",
  CellTags->"Open (menu command)"],
Cell[2182, 70, 175, 6, 14, "Index",
  CellTags->"Close (menu command)"],
Cell[2360, 78, 172, 6, 14, "Index",
  CellTags->"Save (menu command)"],
Cell[2535, 86, 187, 6, 14, "Index",
  CellTags->"Save As (menu command)"],
Cell[2725, 94, 211, 6, 14, "Index",
  CellTags->"Save As Special (menu command)"],
Cell[2939, 102, 276, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[3218, 112, 240, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[3461, 122, 270, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[3734, 132, 282, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[4019, 142, 270, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[4292, 152, 237, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[4532, 162, 239, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[4774, 172, 181, 6, 14, "Index",
  CellTags->"menucommands"],
Cell[4958, 180, 185, 6, 14, "Index",
  CellTags->"menucommands"],
Cell[5146, 188, 178, 6, 14, "Index",
  CellTags->"Import (menu command)"],
Cell[5327, 196, 184, 6, 14, "Index",
  CellTags->"Palettes (menu command)"],
Cell[5514, 204, 187, 6, 14, "Index",
  CellTags->"Notebooks (menu command)"],
Cell[5704, 212, 253, 6, 14, "Index",
  CellTags->"Generate Palette from Selection (menu command)"],
Cell[5960, 220, 250, 6, 14, "Index",
  CellTags->"Generate Notebook from Palette (menu command)"],
Cell[6213, 228, 137, 5, 14, "Index",
  CellTags->"menucommands"],
Cell[6353, 235, 260, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[6616, 245, 278, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[6897, 255, 287, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[7187, 265, 184, 6, 14, "Index",
  CellTags->"Print... (menu command)"],
Cell[7374, 273, 205, 6, 14, "Index",
  CellTags->"Print Selection (menu command)"],
Cell[7582, 281, 173, 6, 14, "Index",
  CellTags->"Quit (menu command)"],
Cell[7758, 289, 172, 6, 14, "Index",
  CellTags->"Undo (menu command)"],
Cell[7933, 297, 169, 6, 14, "Index",
  CellTags->"Cut (menu command)"],
Cell[8105, 305, 172, 6, 14, "Index",
  CellTags->"Copy (menu command)"],
Cell[8280, 313, 175, 6, 14, "Index",
  CellTags->"Paste (menu command)"],
Cell[8458, 321, 175, 6, 14, "Index",
  CellTags->"Clear (menu command)"],
Cell[8636, 329, 211, 6, 14, "Index",
  CellTags->"Paste and Discard (menu command)"],
Cell[8850, 337, 181, 6, 14, "Index",
  CellTags->"Copy As (menu command)"],
Cell[9034, 345, 217, 6, 14, "Index",
  CellTags->"Save Selection As (menu command)"],
Cell[9254, 353, 190, 6, 14, "Index",
  CellTags->"Select All (menu command)"],
Cell[9447, 361, 178, 6, 14, "Index",
  CellTags->"Motion (menu command)"],
Cell[9628, 369, 208, 6, 14, "Index",
  CellTags->"Expression Input (menu command)"],
Cell[9839, 377, 304, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[10146, 387, 292, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[10441, 397, 181, 6, 14, "Index",
  CellTags->"Make 2D (menu command)"],
Cell[10625, 405, 199, 6, 14, "Index",
  CellTags->"Check Balance (menu command)"],
Cell[10827, 413, 191, 6, 14, "Index",
  CellTags->"Shift Left (menu command)"],
Cell[11021, 421, 193, 6, 14, "Index",
  CellTags->"Shift Right (menu command)"],
Cell[11217, 429, 199, 6, 14, "Index",
  CellTags->"Preferences (menu command)"],
Cell[11419, 437, 172, 6, 14, "Index",
  CellTags->"Cell (menu command)"],
Cell[11594, 445, 121, 4, 14, "Index",
  CellTags->"Convert To (menu command)"],
Cell[11718, 451, 250, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[11971, 461, 259, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[12233, 471, 268, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[12504, 481, 253, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[12760, 491, 241, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[13004, 501, 235, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[13242, 511, 253, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[13498, 521, 271, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[13772, 531, 250, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[14025, 541, 121, 4, 14, "Index",
  CellTags->"Display As (menu command)"],
Cell[14149, 547, 235, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[14387, 557, 238, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[14628, 567, 259, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[14890, 577, 268, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[15161, 587, 149, 4, 14, "Index",
  CellTags->"Default Input FormatType (menu command)"],
Cell[15313, 593, 264, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[15580, 603, 273, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[15856, 613, 282, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[16141, 623, 151, 4, 14, "Index",
  CellTags->"Default Output FormatType (menu command)"],
Cell[16295, 629, 268, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[16566, 639, 265, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[16834, 649, 274, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[17111, 659, 283, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[17397, 669, 151, 4, 14, "Index",
  CellTags->"Default Inline FormatType (menu command)"],
Cell[17551, 675, 274, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[17828, 685, 283, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[18114, 695, 131, 4, 14, "Index",
  CellTags->"Cell Properties (menu command)"],
Cell[18248, 701, 255, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[18506, 711, 266, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[18775, 721, 284, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[19062, 731, 275, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[19340, 741, 260, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[19603, 751, 284, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[19890, 761, 127, 4, 14, "Index",
  CellTags->"Cell Grouping (menu command)"],
Cell[20020, 767, 259, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[20282, 777, 265, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[20550, 787, 271, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[20824, 797, 280, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[21107, 807, 193, 6, 14, "Index",
  CellTags->"Divide Cell (menu command)"],
Cell[21303, 815, 193, 6, 14, "Index",
  CellTags->"Merge Cells (menu command)"],
Cell[21499, 823, 235, 6, 14, "Index",
  CellTags->"Animate Selected Graphics (menu command)"],
Cell[21737, 831, 190, 6, 14, "Index",
  CellTags->"Play Sound (menu command)"],
Cell[21930, 839, 211, 6, 14, "Index",
  CellTags->"Rerender Graphics (menu command)"],
Cell[22144, 847, 238, 6, 14, "Index",
  CellTags->"Rerender and Save Graphics (menu command)"],
Cell[22385, 855, 214, 6, 14, "Index",
  CellTags->"Make Standard Size (menu command)"],
Cell[22602, 863, 235, 6, 14, "Index",
  CellTags->"Align Selected Graphics (menu command)"],
Cell[22840, 871, 220, 6, 14, "Index",
  CellTags->"Cell Size Statistics (menu command)"],
Cell[23063, 879, 111, 4, 14, "Index",
  CellTags->"Style (menu command)"],
Cell[23177, 885, 251, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[23431, 895, 239, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[23673, 905, 232, 6, 14, "Index",
  CellTags->"Screen Style Environment (menu command)"],
Cell[23908, 913, 238, 6, 14, "Index",
  CellTags->"Printing Style Environment (menu command)"],
Cell[24149, 921, 205, 6, 14, "Index",
  CellTags->"Show Expression (menu command)"],
Cell[24357, 929, 208, 6, 14, "Index",
  CellTags->"Option Inspector (menu command)"],
Cell[24568, 937, 202, 6, 14, "Index",
  CellTags->"Remove Options (menu command)"],
Cell[24773, 945, 193, 6, 14, "Index",
  CellTags->"Style Sheet (menu command)"],
Cell[24969, 953, 208, 6, 14, "Index",
  CellTags->"Edit Style Sheet (menu command)"],
Cell[25180, 961, 172, 6, 14, "Index",
  CellTags->"Font (menu command)"],
Cell[25355, 969, 172, 6, 14, "Index",
  CellTags->"Face (menu command)"],
Cell[25530, 977, 172, 6, 14, "Index",
  CellTags->"Size (menu command)"],
Cell[25705, 985, 190, 6, 14, "Index",
  CellTags->"Text Color (menu command)"],
Cell[25898, 993, 208, 6, 14, "Index",
  CellTags->"Background Color (menu command)"],
Cell[26109, 1001, 249, 7, 14, "Index",
  CellTags->"Text Alignment (menu command)"],
Cell[26361, 1010, 265, 7, 14, "Index",
  CellTags->"Text Justification (menu command)"],
Cell[26629, 1019, 127, 4, 14, "Index",
  CellTags->"Word Wrapping (menu command)"],
Cell[26759, 1025, 271, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[27033, 1035, 283, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[27319, 1045, 286, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[27608, 1055, 289, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[27900, 1065, 196, 6, 14, "Index",
  CellTags->"Cell Dingbat (menu command)"],
Cell[28099, 1073, 190, 6, 14, "Index",
  CellTags->"Show Ruler (menu command)"],
Cell[28292, 1081, 196, 6, 14, "Index",
  CellTags->"Show Toolbar (menu command)"],
Cell[28491, 1089, 205, 6, 14, "Index",
  CellTags->"Show Pagebreaks (menu command)"],
Cell[28699, 1097, 199, 6, 14, "Index",
  CellTags->"Magnification (menu command)"],
Cell[28901, 1105, 232, 6, 14, "Index",
  CellTags->"Get Graphics Coordinates (menu command)"],
Cell[29136, 1113, 223, 6, 14, "Index",
  CellTags->"3D ViewPoint Selector (menu command)"],
Cell[29362, 1121, 208, 6, 14, "Index",
  CellTags->"Color Selector (menu command)"],
Cell[29573, 1129, 202, 6, 14, "Index",
  CellTags->"Record Sound (menu command)"],
Cell[29778, 1137, 205, 6, 14, "Index",
  CellTags->"Get File Path (menu command)"],
Cell[29986, 1145, 241, 6, 14, "Index",
  CellTags->"Create Table/Matrix/Palette (menu command)"],
Cell[30230, 1153, 199, 6, 14, "Index",
  CellTags->"Create Button (menu command)"],
Cell[30432, 1161, 193, 6, 14, "Index",
  CellTags->"Edit Button (menu command)"],
Cell[30628, 1169, 208, 6, 14, "Index",
  CellTags->"Create Hyperlink (menu command)"],
Cell[30839, 1177, 259, 6, 28, "Index",
  CellTags->"Create Automatic Numbering Object (menu command)"],
Cell[31101, 1185, 241, 6, 14, "Index",
  CellTags->"Create Value Display Object (menu command)"],
Cell[31345, 1193, 223, 6, 14, "Index",
  CellTags->"Copy Input from Above (menu command)"],
Cell[31571, 1201, 226, 6, 14, "Index",
  CellTags->"Copy output from Above (menu command)"],
Cell[31800, 1209, 220, 6, 14, "Index",
  CellTags->"Start New Cell Below (menu command)"],
Cell[32023, 1217, 214, 6, 14, "Index",
  CellTags->"Complete Selection (menu command)"],
Cell[32240, 1225, 199, 6, 14, "Index",
  CellTags->"Make Template (menu command)"],
Cell[32442, 1233, 121, 4, 14, "Index",
  CellTags->"Evaluation (menu command)"],
Cell[32566, 1239, 265, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[32834, 1249, 274, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[33111, 1259, 280, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[33394, 1269, 289, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[33686, 1279, 274, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[33963, 1289, 292, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[34258, 1299, 271, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[34532, 1309, 268, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[34803, 1319, 307, 8, 14, "IndexSubentry",
  CellTags->"menucommands"],
Cell[35113, 1329, 220, 6, 14, "Index",
  CellTags->"Interrupt Evaluation (menu command)"],
Cell[35336, 1337, 208, 6, 14, "Index",
  CellTags->"Abort Evaluation (menu command)"],
Cell[35547, 1345, 196, 6, 14, "Index",
  CellTags->"Start Kernel (menu command)"],
Cell[35746, 1353, 193, 6, 14, "Index",
  CellTags->"Quit Kernel (menu command)"],
Cell[35942, 1361, 202, 6, 14, "Index",
  CellTags->"Default Kernel (menu command)"],
Cell[36147, 1369, 211, 6, 14, "Index",
  CellTags->"Notebook's Kernel (menu command)"],
Cell[36361, 1377, 220, 6, 14, "Index",
  CellTags->"Open Terminal Window (menu command)"],
Cell[36584, 1385, 244, 6, 14, "Index",
  CellTags->"Kernel Configuration Options (menu command)"],
Cell[36831, 1393, 211, 6, 14, "Index",
  CellTags->"Show In/Out Names (menu command)"],
Cell[37045, 1401, 211, 6, 14, "Index",
  CellTags->"Delete All Output (menu command)"],
Cell[37259, 1409, 172, 6, 14, "Index",
  CellTags->"Find (menu command)"],
Cell[37434, 1417, 205, 6, 14, "Index",
  CellTags->"Enter Selection (menu command)"],
Cell[37642, 1425, 187, 6, 14, "Index",
  CellTags->"Find Next (menu command)"],
Cell[37832, 1433, 199, 6, 14, "Index",
  CellTags->"Find Previous (menu command)"],
Cell[38034, 1441, 211, 6, 14, "Index",
  CellTags->"Find in Cell Tags (menu command)"],
Cell[38248, 1449, 181, 6, 14, "Index",
  CellTags->"Replace (menu command)"],
Cell[38432, 1457, 226, 6, 14, "Index",
  CellTags->"Replace and Find Again (menu command)"],
Cell[38661, 1465, 193, 6, 14, "Index",
  CellTags->"Replace All (menu command)"],
Cell[38857, 1473, 199, 6, 14, "Index",
  CellTags->"Open Selected (menu command)"],
Cell[39059, 1481, 217, 6, 14, "Index",
  CellTags->"Scroll to Selection (menu command)"],
Cell[39279, 1489, 181, 6, 14, "Index",
  CellTags->"Go Back (menu command)"],
Cell[39463, 1497, 220, 6, 14, "Index",
  CellTags->"Add/Remove Cell Tags (menu command)"],
Cell[39686, 1505, 187, 6, 14, "Index",
  CellTags->"Cell Tags (menu command)"],
Cell[39876, 1513, 202, 6, 14, "Index",
  CellTags->"Show Cell Tags (menu command)"],
Cell[40081, 1521, 241, 6, 14, "Index",
  CellTags->"Cell Tags from In/Out Names (menu command)"],
Cell[40325, 1529, 193, 6, 14, "Index",
  CellTags->"Make Index... (menu command)"],
Cell[40521, 1537, 199, 6, 14, "Index",
  CellTags->"Stack Windows (menu command)"],
Cell[40723, 1545, 211, 6, 14, "Index",
  CellTags->"Tile Windows Wide (menu command)"],
Cell[40937, 1553, 211, 6, 14, "Index",
  CellTags->"Tile Windows Tall (menu command)"],
Cell[41151, 1561, 178, 6, 14, "Index",
  CellTags->"Help (menu command)"],
Cell[41332, 1569, 202, 6, 14, "Index",
  CellTags->"Find in Help (menu command)"],
Cell[41537, 1577, 205, 6, 14, "Index",
  CellTags->"Why the Beep? (menu command)"],
Cell[41745, 1585, 214, 6, 14, "Index",
  CellTags->"Rebuild Help Index (menu command)"],
Cell[41962, 1593, 44, 0, 39, "IndexSection"],
Cell[42009, 1595, 642, 24, 82, "Index",
  CellTags->"Keyboard shortcuts"],
Cell[42654, 1621, 38, 0, 39, "IndexSection"],
Cell[42695, 1623, 732, 21, 112, "Index",
  CellTags->{"Style sheets", "Environments"}]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

